#include "General.h"
#include "CreditTickChanger.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "RefineryGameObj.h"
#include "RefineryGameObjDef.h"
#include "gmgame.h"

#define GDI 1
#define NOD 0

float CreditTickNod = -1.0f; float CreditTickGDI = -1.0f;
float DumpAmountNod = -1.0f; float DumpAmountGDI = -1.0f;

void Set_Credit_Tick_For_Team(int Team, float CreditTick)
{
	if  (GameObject *Ref = Find_Refinery(Team))
	{
		_asm
		{
			mov     ecx, Ref
			mov		eax, [ecx+6BCh]			// get definition of Ref
			mov		ebx, CreditTick				
			mov     [eax+0A8h], ebx			// Set ref definition's FundsDistributedPerSec
		}
	}
}

void Set_Harvester_Dump_Amount_For_Team(int Team, float DumpAmount)
{
	if  (GameObject *Ref = Find_Refinery(Team))
	{
		_asm
		{
			mov     ecx, Ref
			mov		eax, [ecx+6BCh]			// get definition of Ref
			mov		ebx, DumpAmount				
			mov     [eax+0A4h], ebx			// Set ref definition's FundsGathered
		}
	}
}

CreditTickChanger::CreditTickChanger()
{
	RegisterEvent(EVENT_GLOBAL_INI,this);
	RegisterEvent(EVENT_MAP_INI,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

CreditTickChanger::~CreditTickChanger()
{
	UnregisterEvent(EVENT_GLOBAL_INI,this);
	UnregisterEvent(EVENT_MAP_INI,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void CreditTickChanger::OnLoadGlobalINISettings(INIClass *SSGMIni)
{
}


void CreditTickChanger::OnLoadMapINISettings(INIClass *SSGMIni)
{
	// Get global values
	CreditTickNod = SSGMIni->Get_Float("CreditTickChanger", "CreditTickNod", -1.0f);
	CreditTickGDI = SSGMIni->Get_Float("CreditTickChanger", "CreditTickGDI", -1.0f);
	DumpAmountNod = SSGMIni->Get_Float("CreditTickChanger", "DumpAmountNod", -1.0f);
	DumpAmountGDI =	SSGMIni->Get_Float("CreditTickChanger", "DumpAmountGDI", -1.0f);

	// Get map specific if any else use the global values already set
	const StringClass MapSection = StringClass(The_Game()->Get_Map_Name()).AsLower() +  "_CreditTickChanger";

	CreditTickNod = SSGMIni->Get_Float(MapSection, "CreditTickNod", CreditTickNod);
	CreditTickGDI = SSGMIni->Get_Float(MapSection, "CreditTickGDI", CreditTickGDI);
	DumpAmountNod = SSGMIni->Get_Float(MapSection, "DumpAmountNod", DumpAmountNod);
	DumpAmountGDI =	SSGMIni->Get_Float(MapSection, "DumpAmountGDI", DumpAmountGDI);
}


void CreditTickChanger::OnLoadLevel()
{
	if (CreditTickNod != -1.0f) Set_Credit_Tick_For_Team(NOD, CreditTickNod);
	if (CreditTickGDI != -1.0f) Set_Credit_Tick_For_Team(GDI, CreditTickGDI);

	if (DumpAmountNod != -1.0f) Set_Harvester_Dump_Amount_For_Team(NOD, DumpAmountNod);
	if (DumpAmountGDI != -1.0f) Set_Harvester_Dump_Amount_For_Team(GDI, DumpAmountGDI);
}

CreditTickChanger creditTickChanger;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &creditTickChanger;
}
